import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Filter the dataset to only include grass court matches played between the top 10 players in the last five years
head_to_head_matches = grass_matches[(grass_matches['Player_1'].isin(top_10_player_names)) & (grass_matches['Player_2'].isin(top_10_player_names))]

# Create an empty matrix table to store the head-to-head win-loss records
head_to_head_matrix = pd.DataFrame(np.zeros((10, 10)), columns=top_10_player_names, index=top_10_player_names)

# Populate the matrix table with head-to-head win-loss records
for _, match in head_to_head_matches.iterrows():
 winner = match['Winner']
 loser = match['Player_1'] if match['Player_1'] != winner else match['Player_2']
 head_to_head_matrix.loc[winner, loser] += 1

print(head_to_head_matrix)
pickle.dump(head_to_head_matrix,open("./ref_result/head_to_head_matrix.pkl","wb"))